Because the Team Server is written in Java, the public certificate and private key need to be imported into a Java KeyStore.  Since you won't have the certificates from certbot in your lab, I will use the original `public.crt` and `private.key` files here.

First, we need to combine the separate public and private files into a single PKCS12 file.  Set the password to anything you want, but remember it.

ubuntu@teamserver ~> openssl pkcs12 -inkey private.key -in public.crt -export -out acme.pkcs12
Enter Export Password:
Verifying - Enter Export Password:

  

That PKCS12 file can then be converted to a Java KeyStore using the `keytool` utility.

ubuntu@teamserver ~> keytool -importkeystore -srckeystore acme.pkcs12 -srcstoretype pkcs12 -destkeystore acme.store
Importing keystore acme.pkcs12 to acme.store...
Enter destination keystore password:
Re-enter new password:
Enter source keystore password:
Entry for alias 1 successfully imported.
Import command completed:  1 entries successfully imported, 0 entries failed or cancelled

  

The password of this new store can be the same or different.  At this point, the `.pkcs12` file can be deleted.  The new Java KeyStore needs to be referenced in a Malleable C2 profile before it can be used.

https-certificate {
     set keystore "acme.store";
     set password "password";
}

  

The Cobalt Strike Team Server expects the KeyStore to be in the same directory as itself.  Launch the Team Server with the updated profile.

ubuntu@teamserver ~/cobaltstrike> sudo ./teamserver 10.10.0.69 Passw0rd! c2-profiles/normal/webbug_getonly.profile

[*] Checking TeamServerImage for local update

[*] Verifying MD5 Message Digest for TeamServerImage
TeamServerImage: OK

[*] Will use existing X509 certificate and keystore (for SSL)

[*] Starting teamserver
[*] Team Server Version: 4.6.1 (20220511) Licensed
[*] Setting 'https.protocols' system property: SSLv3,SSLv2Hello,TLSv1,TLSv1.1,TLSv1.2,TLSv1.3
[+] I see you're into threat replication. c2-profiles/normal/webbug_getonly.profile loaded.
[+] Team server is up on 0.0.0.0:50050
[*] SHA256 hash of SSL cert is: e08407b2f751572ae7d1f0e8f5b1a01ba874293fd0b37d66d05843d88f1fbfc2


